function stk_exp_window_gui(varargin)
%This function allows you to use the keyboard to step through a stack in a
%window. Controls: Enter = Quit; < = step left 1 frame; > = step right 1
%frame; right click = play movie; left click = stop movie; center click =
%play movie in reverse. This function is essentially stk_exp_window_global
%with a couple of tweaks in it so it will work in a gui.
%Syntax: stk_exp_windows_global('Stack',stk,'figure',figure_pointr);
%Input: stack = the stack of images
%       axis = the axis pointer
%Output: none

%Make the variables global so the subfunctions can grab them
global STK AX_PTR INDEX IMG_NUM PLAY
warning off all

%catch subfunction calls
if size(varargin,2)==1 && ischar(varargin{1})
    feval(varargin{:});
    return;
else
    %parse the input
    [STK,AX_PTR,INDEX,IMG_NUM] = parse(varargin);
end

%setup callback functions
axes(AX_PTR)
set(gcf, 'WindowButtonDownFcn', 'stk_exp_window_gui(''buttondown'');', ...
        'KeyPressFcn', 'stk_exp_window_gui(''keypress'');',...
        'DeleteFcn', 'stk_exp_window_gui(''cleanup'');');

%Display the first image
axes(AX_PTR)
image(size(STK(:,:,1),2),size(STK(:,:,1),1),STK(:,:,INDEX));
colormap(gray(256));
set(AX_PTR,'Visible','off','Units','pixels')
text(10,10,['frame #: ',num2str(INDEX)],'Color',[1 1 1]);

%Wait for end signal
%waitfor(AX_PTR, 'UserData', 'Completed');

%--------------------------------------------------------------------------
%Subfunction to parse the input
function [STK,AX_PTR,INDEX,IMG_NUM] = parse(input)
%Initiate Parameter Space
INDEX = 1;
AX_PTR = [];

%Parse the input
if ~isempty(input)
    a = size(input,2);
    for i = 1:2:a
        if ischar(input{1,i})
            switch input{1,i}
                case 'stack'
                    STK = input{1,i+1};
                    IMG_NUM = size(STK,3);
                case 'axis'
                    AX_PTR = input{1,i+1};
                otherwise
                    error(['Error: ',input{1,i},' is not a valid input to stk_exp_window.']);
            end
        else
            error(['Error: You have entered an improper argument. Please check Help for how to use stk_exp_window.']);
        end
    end
end

if isempty(AX_PTR)
    %center the figure window
    rez = get(0,'screensize');
    x_size = size(STK,2);
    y_size = size(STK,1);
    x = (rez(3)-x_size)/2;
    y = (rez(4)-y_size)/2;
    AX_PTR = figure('units','pixels','position',[x y x_size y_size],'menubar','none',...
        'toolbar','none','name','Stack Explore');
end

%-------------------------------------------------------------------------
%Subfunction for key response
function keypress 

global STK AX_PTR INDEX IMG_NUM PLAY

key = get(AX_PTR, 'CurrentCharacter');
switch key
    case {char(46)}  %left key
        INDEX = INDEX + 1;
        if INDEX>IMG_NUM
            INDEX = 1;
        end
        axes(AX_PTR)
        image(size(STK(:,:,1),2),size(STK(:,:,1),1),STK(:,:,INDEX));
        colormap(gray(256));
        set(AX_PTR,'Visible','off','Units','pixels')
        text(10,10,['frame #: ',num2str(INDEX)],'Color',[1 1 1]);
        axes(AX_PTR)
        waitsecs(0.02)
    case {char(44)} %right key
        INDEX = INDEX - 1;
        if INDEX<=0
            INDEX = IMG_NUM;
        end
        axes(AX_PTR)
        image(size(STK(:,:,1),2),size(STK(:,:,1),1),STK(:,:,INDEX));
        colormap(gray(256));
        set(AX_PTR,'Visible','off','Units','pixels')
        text(10,10,['frame #: ',num2str(INDEX)],'Color',[1 1 1]);
        axes(AX_PTR)
        waitsecs(0.02)
%     case {char(13), char(3)}   % enter and return keys
%         % return control to line after waitfor
%         %set(AX_PTR, 'UserData', 'Completed');
%         %Clean Up
%         delete(AX_PTR);
end

%-------------------------------------------------------------------------
% Subfunction buttondown
function buttondown 

global STK AX_PTR INDEX IMG_NUM PLAY

mouse_action = get(AX_PTR, 'SelectionType');
switch mouse_action
    case 'open'
        % We're done! double click
        %set(AX_PTR, 'UserData', 'Completed');
        %Clean Up
        %delete(AX_PTR);
    case 'normal'
        %left click
        PLAY = 1;
        axes(AX_PTR)
        for i = INDEX:IMG_NUM
            if PLAY
                image(size(STK(:,:,1),2),size(STK(:,:,1),1),STK(:,:,i));
                colormap(gray(256));
                set(AX_PTR,'Visible','off','Units','pixels')
                text(10,10,['frame #: ',num2str(i)],'Color',[1 1 1]);
                axes(AX_PTR)
                waitsecs(0.05);
                INDEX = i;
            end
        end
        PLAY = 0;
    case 'alt'
        %right click
        PLAY = 0;
    case 'extend'
        %third button or both buttons together
        PLAY = 1;
        axes(AX_PTR)
        if INDEX==1
            INDEX = IMG_NUM;
        end
        for i = INDEX:-1:1
            if PLAY
                image(size(STK(:,:,1),2),size(STK(:,:,1),1),STK(:,:,i));
                colormap(gray(256));
                set(AX_PTR,'Visible','off','Units','pixels')
                text(10,10,['frame #: ',num2str(i)],'Color',[1 1 1]);
                axes(AX_PTR)
                waitsecs(0.05);
                INDEX = i;
            end
        end
        PLAY = 0;
end

%-------------------------------------------------------------------------
% clean up function
function cleanup 

clear global STK AX_PTR INDEX IMG_NUM PLAY